﻿//////////////////////////////////////////////
// ContentLoader.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class System ;
}

namespace nkExport
{
	class Exportable ;
	class Node ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../Dll/DllDefines.h"

#include "ContentLoadResult.h"

// nkExport
#include <NilkinsExport/Exporter/ExporterLoadResult.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT ContentLoader final
	{
		public :

			// Constructor
			ContentLoader (System* system) noexcept ;

			// Functions from nkGraphics originally
			// Could be nice to push into nkExport (TODO)
			// Practical functions
			nkExport::ExporterLoadResult inputData (nkMemory::StringView filePath) ;
			nkMemory::String inputDataStr (nkMemory::StringView filePath) ;
			nkExport::ExporterLoadResult inputDataSources (nkMemory::StringView sources) ;
			bool outputData (nkMemory::StringView content, nkMemory::StringView path) ;

			// Save
			bool saveTreeDeclaration (nkExport::Node* tree, nkMemory::StringView pathFromData) ;
			bool saveObjectDeclaration (nkExport::Exportable* object, nkMemory::StringView pathFromData) ;

			// Materials
			ContentLoadResultMaterial loadMaterialDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			ContentLoadResultMaterial processMaterialSources (nkMemory::StringView sources, bool loadResource = true) ;
			ContentLoadResultMaterial processMaterialTree (nkExport::Node* tree, bool loadResource = true) ;

		private :

			// Attributes
			System* _system ;
	} ;
}